/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.AnalogOrBlockReference;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;

public class AnalogWatchdogParameter
extends Analog {
    static final long serialVersionUID = -7083901590768998402L;
    private int blockSerializedDataVersion = 2;
    private static final int MAX_DELTA = 20000;
    private static final int MIN_DELTA = 0;
    private AnalogValueProperties fAenProperties;
    private static final int WAIT_EN = 0;
    private static final int COMPARE = 1;
    private int fDelta;
    private transient AnalogValueProperties fDeltaProperties;
    private transient AnalogValueProperties fDeltaProperties01;
    private transient AnalogValueProperties fDeltaProperties02;
    private AnalogOrBlockReference fDelta01Refer;
    private AnalogOrBlockReference fDelta02Refer;
    private transient int fAen;

    public AnalogWatchdogParameter() {
    }

    public AnalogWatchdogParameter(Block block) {
        super(block);
    }

    public void updateRemanenceAvailable(Block block) {
        if (block != null) {
            Hardware hardware = block.getHardware();
            if (hardware != null && hardware.supports("analogWatchdogWithRetentivity")) {
                this.setRemanenceAvailable(true);
            } else {
                this.setRemanenceAvailable(false);
            }
        }
    }

    public AnalogValueProperties getDeltaProperties() {
        if (this.fDeltaProperties == null) {
            this.fDeltaProperties = new AnalogValueProperties(MIN_TRIGGER, MAX_TRIGGER, 1, this.getDelta(), this.getDecimalPlace(), this.isAnalogValueDecimalPlacesAvailable(), "error.dialog.invalidValue", "Invalid value");
            return this.fDeltaProperties;
        }
        this.fDeltaProperties.setCurrentValue(this.getDelta());
        this.fDeltaProperties.setDecimalPlace(this.getDecimalPlace());
        this.fDeltaProperties.setSuppressLeadingZeroes(this.isAnalogValueDecimalPlacesAvailable());
        return this.fDeltaProperties;
    }

    public AnalogOrBlockReference getDeltaTrigger01() {
        if (this.fDelta01Refer == null) {
            this.fDelta01Refer = new AnalogOrBlockReference(this);
            this.fDeltaProperties01 = new AnalogValueProperties(0, MAX_TRIGGER, 1, 0, 0, "error.dialog.invalidValue", "Invalid value");
            this.fDeltaProperties01.setSuppressLeadingZeroes(this.isAnalogValueDecimalPlacesAvailable());
            this.fDelta01Refer.setAnalogValueProperties(this.fDeltaProperties01);
            this.fDelta01Refer.setIntValue(this.fDelta);
        }
        this.fDelta01Refer.setDecimalPlace(this.getDecimalPlace());
        return this.fDelta01Refer;
    }

    public void setDeltaTrigger01(AnalogOrBlockReference value) {
        this.getDeltaTrigger01().setValue(value);
    }

    public AnalogOrBlockReference getDeltaTrigger02() {
        if (this.fDelta02Refer == null) {
            this.fDelta02Refer = new AnalogOrBlockReference(this);
            this.fDeltaProperties02 = new AnalogValueProperties(0, MAX_TRIGGER, 1, 0, 0, "error.dialog.invalidValue", "Invalid value");
            this.fDeltaProperties02.setSuppressLeadingZeroes(this.isAnalogValueDecimalPlacesAvailable());
            this.fDelta02Refer.setAnalogValueProperties(this.fDeltaProperties02);
            this.fDelta02Refer.setIntValue(this.fDelta);
        }
        this.fDelta02Refer.setDecimalPlace(this.getDecimalPlace());
        return this.fDelta02Refer;
    }

    public void setDeltaTrigger02(AnalogOrBlockReference value) {
        this.getDeltaTrigger02().setValue(value);
    }

    public void setDeltaProperties(AnalogValueProperties deltaProperties) {
        this.getDeltaTrigger01().setIntValue(Math.abs(deltaProperties.getCurrentValue()));
        this.getDeltaTrigger02().setIntValue(Math.abs(deltaProperties.getCurrentValue()));
    }

    public AnalogValueProperties getDeltaProperties01() {
        return this.getDeltaTrigger01().getAnalogValueProperties();
    }

    public void setDeltaProperties01(AnalogValueProperties deltaProperties01) {
        this.getDeltaTrigger01().setAnalogValueProperties(deltaProperties01);
    }

    public AnalogValueProperties getDeltaProperties02() {
        return this.getDeltaTrigger02().getAnalogValueProperties();
    }

    public void setDeltaProperties02(AnalogValueProperties deltaProperties02) {
        this.getDeltaTrigger02().setAnalogValueProperties(deltaProperties02);
    }

    public int getDelta() {
        if (this.getDeltaTrigger01().isReference()) {
            return 0;
        }
        return this.getDeltaTrigger01().getValue();
    }

    public int getDelta01() {
        return this.getDeltaTrigger01().getValue();
    }

    public int getDelta02() {
        return this.getDeltaTrigger02().getValue();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        if (this.getDeltaTrigger01().getValue() == this.getDeltaTrigger02().getValue()) {
            this.fDelta = this.getDeltaTrigger01().getValue();
        }
        dw.writeInt(this.fDelta);
        dw.writeStorable(this.fDelta01Refer);
        dw.writeStorable(this.fDelta02Refer);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fDelta = dr.readInt();
        this.fDelta01Refer = (AnalogOrBlockReference)dr.readStorable();
        this.fDelta02Refer = (AnalogOrBlockReference)dr.readStorable();
    }

    public void setDelta(int delta) {
        this.getDeltaTrigger01().setIntValue(Math.abs(delta));
        this.getDeltaTrigger02().setIntValue(Math.abs(delta));
    }

    public void setDelta01(int delta) {
        this.getDeltaTrigger01().setIntValue(delta);
    }

    public void setDelta01(IntegerOrBlockReference value) {
        this.getDeltaTrigger01().setValue(value);
    }

    public void setDelta02(int delta) {
        this.getDeltaTrigger02().setIntValue(delta);
    }

    public void setDelta02(IntegerOrBlockReference value) {
        this.getDeltaTrigger02().setValue(value);
    }

    protected String calculateCurrentParameterText() {
        String currentParameterText = Util.addTrailingSpaces(Integer.toString(this.fAmplifiedX), 6) + "\n" + Integer.toString(this.fAen);
        return currentParameterText;
    }

    public boolean getValue(boolean enable, double ax) {
        boolean result = this.calculateValue(enable, ax);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return result;
    }

    private boolean calculateValue(boolean enable, double ax) {
        this.fXInput = ax;
        this.fAmplifiedX = this.getMeasurement().getAmplifiedValue((int)ax);
        int bottom = this.fAen - this.getDeltaTrigger02().getValue(0, 20000);
        int top = this.fAen + this.getDeltaTrigger01().getValue(0, 20000);
        boolean result = false;
        switch (this.fState) {
            case 0: {
                if (!enable) break;
                this.fAen = this.fAmplifiedX;
                this.fState = 1;
                break;
            }
            case 1: {
                if (enable) {
                    if (bottom <= this.fAmplifiedX && this.fAmplifiedX <= top) break;
                    result = true;
                    break;
                }
                this.fAen = 0;
                this.fState = 0;
            }
        }
        return result;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        if (!this.getRemanenceAvailable() || !this.getRemanenceObject().getRemanence() || forceReset) {
            this.fAen = 0;
            this.fState = 0;
        }
    }

    public String getParameterText() {
        StringBuffer result = new StringBuffer();
        result.append("Threshold 1=").append(this.getDeltaTrigger01().getParameterText()).append(this.getProtectionSign()).append("\n").append("Threshold 2=").append(this.getDeltaTrigger02().getParameterText()).append("\n").append("Gain=").append(this.getGainString()).append("\n").append("Offset=").append(this.fMeasurement.getOffset()).append("\n").append("Point=").append(this.getDecimalPlace());
        return result.toString();
    }

    public AnalogValueProperties getAenProperties() {
        if (this.fAenProperties == null) {
            this.fAenProperties = new AnalogValueProperties((int)this.fMeasurement.getMinMeasuredValue(), (int)this.fMeasurement.getMaxMeasuredValue(), 1, 0, 0, this.isAnalogValueDecimalPlacesAvailable(), "error.dialog.invalidValue", "Invalid value");
        }
        this.fAenProperties.setCurrentValue(this.fAen);
        this.fAenProperties.setDecimalPlace(this.getDecimalPlace());
        return this.fAenProperties;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.getDeltaTrigger01().getValue() == this.getDeltaTrigger02().getValue()) {
            this.fDelta = this.getDeltaTrigger01().getValue();
        }
        s.defaultWriteObject();
    }

    public boolean isAvailable(Hardware hardware, List errorList) {
        boolean result = super.isAvailable(hardware, errorList);
        if ((this.getDeltaTrigger01().isReference() || this.getDeltaTrigger02().isReference()) && !hardware.supports("AnalogWatchdog_ref")) {
            errorList.add(new ErrorInfo(this, Language.getString("error.hardware.referenceNotSupported", "The reference is not supported by the device %.", hardware.getLocalizedPath() + hardware.getLocalizedName()), hardware));
            result &= false;
        }
        if (this.getDeltaTrigger01().getValue() != this.getDeltaTrigger02().getValue() && !hardware.supports("analogWatchdogWithTwoDelta")) {
            errorList.add(new ErrorInfo(this, "error.convert.analogWatchdog.delta", hardware));
            result = false;
        }
        if (this.getRemanenceAvailable() && !hardware.supports("analogWatchdogWithRetentivity") && this.getRemanenceObject().getRemanence()) {
            errorList.add(new ErrorInfo(this, "error.convert.rem", hardware));
            return false;
        }
        return result;
    }
}

